\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{congrumitaa}[2019/06/26 v1]

\LoadClass[11pt,a4paper]{amsart}
\RequirePackage[american]{babel}
\RequirePackage[T1]{fontenc}
\RequirePackage{amssymb}
\RequirePackage{amscd}
\RequirePackage{graphicx}
\RequirePackage{xcolor}   
\RequirePackage{geometry}

% page's dimension
\setlength\textwidth{16cm}
\setlength\@tempdima        {\paperwidth}
\addtolength\@tempdima      {-\textwidth}
\setlength\oddsidemargin    {.5\@tempdima}
\addtolength\oddsidemargin  {-1in}
\setlength\evensidemargin   \oddsidemargin
\setlength\textheight       {25cm}
\setlength\topmargin        {\z@}


% top of the page


\def\logo{{}\hfill


%\begin{flushleft}
%\includegraphics[scale=0.2]{logo_TAA}
%\end{flushleft}


\begin{flushright}

\vspace{-50pt}
	\begin{tabular}{c}\hline
	II International Conference \\ on Approximation Theory \\ and Applications\\
	{\footnotesize Gaeta, 14--18 September 2026}\\
	\hline\end{tabular}
	\end{flushright}
	\vspace*{15pt}\nopagebreak}
\AtBeginDocument{\thispagestyle{empty}\logo}

% theorem, definitions, etc.
\newtheorem{theorem}{Theorem}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{corollary}[theorem]{Corollary}
\theoremstyle{definition}
\newtheorem{definition}{Definition}
\let\proof\proof
\let\endproof\endproof

% intestazione

\newtoks\@toksintestazione
\newtoks\@tokstitle
\newtoks\@toksemail

% controllo se \affiliation e' preceduto da almeno un \author o \author*
\newif\if@utore
\@utorefalse
% controllo se c'e' esattamente un comando \author*
\newif\if@utorestar
\@utorestarfalse\def\title#1{\@tokstitle={#1}}

\def\author{\@ifstar{\@utorestar}{\@utore}}
\def\@utorestar#1{%
	\if@utorestar
	\ClassError{congrumitaa}{Twice \protect\author*}{The command \protect\author* must be used once only for the speaker}
	\fi
	\if@utore
	\@toksintestazione=\expandafter{\the\@toksintestazione,\space}
	\else
	\@toksintestazione=\expandafter{\the\@toksintestazione
	\bgroup\itshape}
	\fi
%
	\@toksintestazione=\expandafter{\the\@toksintestazione\temp{#1}}
	\@utorestartrue
	\@utoretrue}
\def\@utore#1{%
	\if@utore
	\@toksintestazione=\expandafter{\the\@toksintestazione,\space}
	\else
	\@toksintestazione=\expandafter{\the\@toksintestazione
	\bgroup\itshape}
	\fi
	\@toksintestazione=\expandafter{\the\@toksintestazione#1}
	\@utoretrue
	\un@utorefalse}
\def\affiliation#1{%
	\if@utore
	\@toksintestazione=\expandafter{\the\@toksintestazione\egroup}
	\else
	\ClassError{congrumitaa}{\noexpand\affiliation must be inserted after the command author}{}
	\fi
	\@toksintestazione=\expandafter{\the\@toksintestazione
	\par{#1}\par\vspace*{4pt}}
	\@utorefalse}
\def\intestazione{%
	\if@utorestar
	\else
	\ClassError{congrumitaa}{Manca il comando \protect\author*}{Nel file 
	deve comparire il comando \protect\author*, con argomento il nome 
	dell'author che presenta la pubblicazione}
	\fi
	{\centering
	\textbf{\Large\the\@tokstitle\\}\vspace*{3mm}
% se ci sono piu' autori quello che presenta la comunicazione viene 
% sottolineato
	\ifun@utore
	\let\temp\relax
	\else
	\let\temp\underline
	\fi
	\the\@toksintestazione\@thanks\vspace*{6pt}}
% \titolo \author \author* \affiliation devono precedere \intestazione
	\def\title{\ClassError{congrumitaa}{Il comando \noexpand\title
	deve comparire prima di \noexpand\intestazione}{}}
	\def\@utorestar{\ClassError{congrumitaa}{Il comando \protect\author* 
	deve comparire prima di \noexpand\intestazione}{}}
	\def\@utore{\ClassError{congrumitaa}{Il comando \noexpand\author
	deve comparire prima di \noexpand\intestazione}{}}
	\def\affiliation{\ClassError{congrumitaa}{Il comando \noexpand\affiliation
	deve comparire prima di \noexpand\intestazione}{}}}

% controllo se c'e' un solo author
\newif\ifun@utore
\un@utoretrue
% controllo se c'e' il comando \email
\newif\ifem@il
\em@ilfalse


\def\title#1{\@tokstitle={#1}}

\def\author{\@ifstar{\@utorestar}{\@utore}}
\def\@utorestar#1{%
	\if@utorestar
	\ClassError{congrumitaa}{Twice \protect\author*}{The command \protect\author* must be used once only for the speaker}
	\fi
	\if@utore
	\@toksintestazione=\expandafter{\the\@toksintestazione,\space}
	\else
	\@toksintestazione=\expandafter{\the\@toksintestazione
	\bgroup\itshape}
	\fi
%
	\@toksintestazione=\expandafter{\the\@toksintestazione\temp{#1}}
	\@utorestartrue
	\@utoretrue}
\def\@utore#1{%
	\if@utore
	\@toksintestazione=\expandafter{\the\@toksintestazione,\space}
	\else
	\@toksintestazione=\expandafter{\the\@toksintestazione
	\bgroup\itshape}
	\fi
	\@toksintestazione=\expandafter{\the\@toksintestazione#1}
	\@utoretrue
	\un@utorefalse}
\def\affiliation#1{%
	\if@utore
	\@toksintestazione=\expandafter{\the\@toksintestazione\egroup}
	\else
	\ClassError{congrumitaa}{\noexpand\affiliation must be inserted after the command author}{}
	\fi
	\@toksintestazione=\expandafter{\the\@toksintestazione
	\par{#1}\par\vspace*{4pt}}
	\@utorefalse}
\def\intestazione{%
	\if@utorestar
	\else
	\ClassError{congrumitaa}{Manca il comando \protect\author*}{Nel file 
	deve comparire il comando \protect\author*, con argomento il nome 
	dell'author che presenta la pubblicazione}
	\fi
	{\centering
	\textbf{\Large\the\@tokstitle\\}\vspace*{3mm}
% se ci sono piu' autori quello che presenta la comunicazione viene 
% sottolineato
	\ifun@utore
	\let\temp\relax
	\else
	\let\temp\underline
	\fi
	\the\@toksintestazione\@thanks\vspace*{6pt}}
% \titolo \author \author* \affiliation devono precedere \intestazione
	\def\title{\ClassError{congrumitaa}{Il comando \noexpand\title
	deve comparire prima di \noexpand\intestazione}{}}
	\def\@utorestar{\ClassError{congrumitaa}{Il comando \protect\author* 
	deve comparire prima di \noexpand\intestazione}{}}
	\def\@utore{\ClassError{congrumitaa}{Il comando \noexpand\author
	deve comparire prima di \noexpand\intestazione}{}}
	\def\affiliation{\ClassError{congrumitaa}{Il comando \noexpand\affiliation
	deve comparire prima di \noexpand\intestazione}{}}}

\def\email#1{\@toksemail{E--mail: \texttt{#1}.}\em@iltrue}

\AtEndDocument{%
	\def\@thefnmark{}
	\ifem@il
	\@footnotetext{\the\@toksemail}
	\fi
}
% bibliografia
\newenvironment{references}
{\sloppy\par\medskip\noindent\textbf{References}\list{\labelenumi}{%
	\def\labelenumi{[\theenumi]}
	\usecounter{enumi}
	\itemindent0pt
	\settowidth\labelwidth{[9]}
	\leftmargin\labelwidth\advance\leftmargin\labelsep
	\itemsep3ptplus1ptminus.5pt
	\topsep4ptplus1ptminus.5pt
	\parsep0pt
	\partopsep0pt}}
{\endlist}

% disattivazione di \renewcommand \renewenvironment
\def\renewcommand{%
	\ClassError{congrumitaa}{Le macro non possono essere ridefinite, quindi
	il comando \noexpand\renewcommand non puo' essere utilizzato}{}}
\def\renewenvironment{%
	\ClassError{congrumitaa}{Gli ambienti non possono essere ridefiniti, quindi
	il comando \noexpand\renewenvironment non puo' essere utilizzato}{}}

% definizione di \thanks come in LaTeX originale
\def\thanks#1{\footnotemark
	\protected@xdef\@thanks{\@thanks
	\protect\footnotetext[\the\c@footnote]{#1}}}
\let\@thanks\@empty
